// Flip.cpp

#include "../../SSoundStream.h"

#pragma export on
extern "C" char *s_name = "Flip";
extern "C" char *s_copyright = "Copyright © 1997-98 Olivier Wittenberg";
extern "C" char *s_version = "1.0";

extern "C" __declspec(dllexport) void s_process_sound(SSoundStream *, SSoundStream *, bool *);
#pragma export reset

// The function almost runs in its own thread, so the stack is still >> 8Kb.
const int32 bufsize = 8192;

void s_process_sound(SSoundStream *inStream, SSoundStream *outStream, bool *quit_asap)
{
	// The stack is large enough.
	uint8 buffer[bufsize];

	// Try to avoid unnecessary calls to the streams.
	const off_t framecount   = inStream->CountFrames();
	const int32 framesize    = inStream->FrameSize(),
	            channelcount = inStream->CountChannels(),
	            framesperbuf = bufsize / framesize;
	off_t position;

	// We won't read the file in a linear way: we'd better disable the reading ahead
	inStream->SetReadingAhead(false);

	for (position = framecount - framesperbuf;
	     !*quit_asap && position != -framesperbuf;
	     position -= framesperbuf)
	{
		size_t toread = framesperbuf;

		if (position < 0)
		{
			toread += position;
			position = 0;
		}

		inStream->SeekToFrame(position);
		const ssize_t readframes = inStream->ReadFrames(buffer, toread);
		const int32 maxbytes = framesize * readframes - 1;

		// Actually process the data
		for (int32 i = 0; i < (maxbytes + 1) / 2; i += framesize)
			if (channelcount == 1)
			{
				int16 t = ((int16 *)buffer)[i / 2];

				((int16 *)buffer)[i / 2] = ((int16 *)buffer)[(maxbytes - i) / 2];
				((int16 *)buffer)[(maxbytes - i) / 2] = t;
			}
			else
			{
				int16 t;

				t = ((int16 *)buffer)[i / 2];
				((int16 *)buffer)[i / 2] = ((int16 *)buffer)[(maxbytes - i) / 2];
				((int16 *)buffer)[(maxbytes - i) / 2] = t;

				t = ((int16 *)buffer)[i / 2 + 1];
				((int16 *)buffer)[i / 2 + 1] = ((int16 *)buffer)[(maxbytes - i) / 2 - 1];
				((int16 *)buffer)[(maxbytes - i) / 2 - 1] = t;
			}

		outStream->WriteFrames(buffer, readframes);
	}
}